<?php
// admin_home_categories.php
// +------------------------------------------------------------------------+
// | PHP Melody Admin - Manage Home Page Categories                         |
// +------------------------------------------------------------------------+

// عرض الأخطاء لتسهيل التطوير (تفعيل في بيئة التطوير فقط)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// بدء الجلسة وتحميل الإعدادات
session_start();
require_once __DIR__ . '/../config.php';
require_once ABSPATH . 'include/functions.php';
require_once ABSPATH . 'include/user_functions.php';
require_once ABSPATH . 'include/islogged.php';

// حماية الصفحة — مسموح فقط للأدمن والمشرف والمحرر
if (!(is_user_logged_in() && (is_admin() || is_moderator() || is_editor()))) {
    header('Location: ' . _URL . '/' . _ADMIN_FOLDER . '/login.php');
    exit;
}

// إنشاء اتصال MySQLi
$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
if ($conn->connect_error) {
    die('❌ خطأ اتصال بقاعدة البيانات: ' . $conn->connect_error);
}
$conn->set_charset('utf8mb4');

// معالجة حفظ التغييرات عند POST
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])) {
    // حذف السجلات الحالية
    $conn->query("TRUNCATE TABLE home_categories");
    if (!empty($_POST['category_id']) && is_array($_POST['category_id'])) {
        $stmt = $conn->prepare(
            "INSERT INTO home_categories (category_id, custom_title, image_url, enabled, sort_order) VALUES (?, ?, ?, ?, ?)"
        );
        foreach ($_POST['category_id'] as $i => $cat_id) {
            $cid     = (int) $cat_id;
            if ($cid <= 0) continue;
            $title   = trim($_POST['custom_title'][$i]);
            $img     = trim($_POST['image_url'][$i]);
            $enabled = isset($_POST['enabled'][$i]) ? 1 : 0;
            $order   = (int) $_POST['sort_order'][$i];
            $stmt->bind_param('issii', $cid, $title, $img, $enabled, $order);
            $stmt->execute();
        }
        $stmt->close();
        $msg = '✅ تم حفظ إعدادات أقسام الصفحة الرئيسية بنجاح.';
    }
}

// جلب جميع الأقسام المتاحة
$res = $conn->query("SELECT id, name, tag FROM pm_categories ORDER BY name ASC");
$all_cats = [];
while ($r = $res->fetch_assoc()) {
    $all_cats[$r['id']] = $r;
}
$res->free();

// جلب إعدادات الصفحة الرئيسية
$res = $conn->query("SELECT * FROM home_categories ORDER BY sort_order ASC");
$home_cats = [];
while ($r = $res->fetch_assoc()) {
    $home_cats[] = $r;
}
$res->free();

// توفير صف افتراضي إذا لم توجد إعدادات
if (empty($home_cats)) {
    foreach (array_slice(array_keys($all_cats), 0, 5) as $i => $cid) {
        $home_cats[] = [
            'category_id'  => $cid,
            'custom_title' => $all_cats[$cid]['name'],
            'image_url'    => '',
            'enabled'      => 0,
            'sort_order'   => $i + 1
        ];
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إعدادات أقسام الصفحة الرئيسية</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <style> .table td { vertical-align: middle; } </style>
</head>
<body class="p-4 bg-light">
<div class="container">
    <h1 class="mb-4">🏠 إعدادات أقسام الصفحة الرئيسية</h1>

    <?php if ($msg): ?>
        <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
    <?php endif; ?>

    <form method="post">
        <input type="hidden" name="save" value="1">

        <div class="mb-3 text-start">
            <button type="button" id="add-section-btn" class="btn btn-success">➕ إضافة قسم جديد</button>
        </div>

        <table class="table table-bordered bg-white">
            <thead class="table-light">
                <tr>
                    <th>#</th>
                    <th>القسم</th>
                    <th>العنوان المخصص</th>
                    <th>رابط الصورة</th>
                    <th>معروض؟</th>
                    <th>ترتيب العرض</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($home_cats as $i => $hc): 
                $cid = (int) $hc['category_id'];
                $cat = $all_cats[$cid] ?? null;
                if (!$cat) continue;
            ?>
                <tr>
                    <td><?= $i+1 ?></td>
                    <td>
                        <?= htmlspecialchars($cat['name']) ?>
                        <input type="hidden" name="category_id[]" value="<?= $cid ?>">
                    </td>
                    <td><input type="text" name="custom_title[]" class="form-control" value="<?= htmlspecialchars($hc['custom_title']) ?>" placeholder="اختياري"></td>
                    <td><input type="url" name="image_url[]" class="form-control" value="<?= htmlspecialchars($hc['image_url']) ?>" placeholder="https://"></td>
                    <td class="text-center"><input type="checkbox" name="enabled[<?= $i ?>]" value="1" <?= $hc['enabled'] ? 'checked' : '' ?>></td>
                    <td><input type="number" name="sort_order[]" class="form-control" value="<?= (int)$hc['sort_order'] ?>" style="width:80px;"></td>
                </tr>
            <?php endforeach; ?>

            <!-- Template row مخفي لإضافة أقسام جديدة -->
            <tr id="section-template" class="d-none">
                <td>#</td>
                <td>
                    <select name="category_id[]" class="form-select">
                        <option value="">-- اختر القسم --</option>
                        <?php foreach ($all_cats as $id => $c): ?>
                            <option value="<?= $id ?>"><?= htmlspecialchars($c['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </td>
                <td><input type="text" name="custom_title[]" class="form-control" placeholder="اختياري"></td>
                <td><input type="url" name="image_url[]" class="form-control" placeholder="https://"></td>
                <td class="text-center"><input type="checkbox" name="enabled[new]" value="1"></td>
                <td><input type="number" name="sort_order[]" class="form-control" value="0" style="width:80px;"></td>
            </tr>
            </tbody>
        </table>

        <div class="text-end">
            <button type="submit" class="btn btn-primary">💾 حفظ الإعدادات</button>
        </div>
    </form>
</div>

<script>
// إضافة قسم جديد ديناميكيًا
document.getElementById('add-section-btn').addEventListener('click', function() {
    var tbody    = this.closest('form').querySelector('tbody');
    var template = document.getElementById('section-template');
    var clone    = template.cloneNode(true);
    clone.id     = '';
    clone.classList.remove('d-none');
    // إعادة ترقيم العمود الأول
    var rows = tbody.querySelectorAll('tr:not(#section-template)');
    clone.querySelector('td:first-child').textContent = rows.length;
    // تعديل اسم checkbox
    var cb = clone.querySelector('input[type=checkbox]');
    cb.name = 'enabled[' + (rows.length-1) + ']';
    tbody.insertBefore(clone, template);
});
</script>
</body>
</html>
