<?php
// +------------------------------------------------------------------------+
// | PHP Melody ( www.phpsugar.com )
// +------------------------------------------------------------------------+
// | PHP Melody IS NOT FREE SOFTWARE
// | Copyright: (c) 2004-2013 PHPSUGAR. All rights reserved.
// +------------------------------------------------------------------------+

// Session Cookie workaround
if (isset($_POST["PHPSESSID"])) {
    session_id($_POST["PHPSESSID"]);
} elseif (isset($_GET["PHPSESSID"])) {
    session_id($_GET["PHPSESSID"]);
}
session_start();

header('Content-Type: text/plain; charset=utf-8');

require_once('../config.php');
require_once('functions.php');
require_once(ABSPATH . 'include/user_functions.php');
require_once(ABSPATH . 'include/islogged.php');

// Early exit for non-authenticated users
if (!$logged_in) {
    header('Location: login.php');
    exit();
}

// Check permissions
if (!(is_admin() || is_moderator() || is_editor())) {
    echo pm_alert_error('Access denied', ['id' => '_error_']);
    exit();
}

// Validate file upload
if (empty($_POST['Filename']) || !isset($_FILES['Filedata']) || !is_uploaded_file($_FILES['Filedata']['tmp_name'])) {
    echo pm_alert_error('Select a valid file first.', ['id' => '_error_']);
    exit();
}

$file = $_FILES['Filedata'];
$whitelist = ['.jpg', '.gif', '.png', '.jpeg'];
$upload_errors = [
    1 => "The uploaded file exceeds the upload_max_filesize directive in php.ini",
    2 => "The uploaded file exceeds the MAX_FILE_SIZE directive",
    3 => "The uploaded file was only partially uploaded",
    4 => "No file was uploaded",
    6 => "Missing a temporary folder"
];

// File validation
$ext = strtolower(strrchr($file['name'], '.'));
if (!in_array($ext, $whitelist)) {
    echo pm_alert_error('Invalid file type. Allowed: ' . implode(', ', $whitelist), ['id' => '_error_']);
    exit();
}

if ($file['error'] !== UPLOAD_ERR_OK) {
    $error = $upload_errors[$file['error']] ?? 'Unknown upload error';
    echo pm_alert_error($error, ['id' => '_error_']);
    exit();
}

if ($file['size'] <= 0) {
    echo pm_alert_error('File is empty or invalid.', ['id' => '_error_']);
    exit();
}

// Process different upload types
$action = $_POST['doing'] ?? 'default';
switch ($action) {
    case 'logo':
        processLogo($file, $ext);
        break;
        
    case 'video-thumb':
        processVideoThumb($file);
        break;
        
    case 'category-image':
        processCategoryImage($file);
        break;
        
    default:
        processArticleAttachment($file, $ext);
}

exit();

// Function definitions
function processArticleAttachment($file, $ext) {
    require_once('img.resize.php');
    
    $new_name = substr(md5($file['name'] . time()), 1, 8) . $ext;
    $uploadFile = _ARTICLE_ATTACH_DIR_PATH . $new_name;
    
    if (!move_uploaded_file($file['tmp_name'], $uploadFile)) {
        echo pm_alert_error('Failed to move uploaded file.', ['id' => '_error_']);
        return;
    }

    // Create thumbnail
    $thumb_name = str_replace($ext, '_th'.$ext, $uploadFile);
    resize_then_crop($uploadFile, $thumb_name, THUMB_W_ARTICLE, THUMB_H_ARTICLE, "255", "255", "255");
    
    // Get image dimensions
    list($width, $height) = getimagesize($uploadFile);
    $maxWidth = 500;
    $use_lightbox = $width > $maxWidth;
    
    if ($use_lightbox) {
        $ratio = $maxWidth / $width;
        $width = $maxWidth;
        $height = (int)($height * $ratio);
    }
    
    $file_url = make_url_relative(_ARTICLE_ATTACH_DIR . $new_name);
    $html = '<img src="'. $file_url .'" width="'. $width .'" height="'. $height .'" vspace="" hspace="" border="0" alt="" />';
    
    if ($use_lightbox) {
        $html = '<a href="'. $file_url .'" rel="prettyPhoto[phpmelody]">'. $html .'</a>';
    }
    
    echo $html;
}

function processLogo($file, $ext) {
    $new_name = 'custom-logo' . $ext;
    
    if (is_writeable(ABSPATH . _UPFOLDER)) {
        $uploadFile = ABSPATH . _UPFOLDER .'/'. $new_name;
        $file_url = _URL .'/'. _UPFOLDER .'/'. $new_name;
    } else {
        $uploadFile = _THUMBS_DIR_PATH . $new_name;
        $file_url = _THUMBS_DIR . $new_name;
    }
    
    if (!move_uploaded_file($file['tmp_name'], $uploadFile)) {
        echo pm_alert_error('Failed to move logo file.', ['id' => '_error_']);
        return;
    }

    // Get dimensions
    list($width, $height) = getimagesize($uploadFile);
    $maxWidth = 500;
    
    if ($width > $maxWidth) {
        $ratio = $maxWidth / $width;
        $width = $maxWidth;
        $height = (int)($height * $ratio);
    }
    
    $file_url = make_url_relative($file_url);
    $html = '<img src="'. $file_url .'?cachebuster='. time() .'" width="'. $width .'" height="'. $height .'" vspace="" hspace="" border="0" alt="" />';
    $html .= '<input type="hidden" name="custom_logo_url" value="'. $file_url .'" />';
    
    echo $html;
}

function processVideoThumb($file) {
    require_once('img.resize.php');
    
    $img = new resize_img();
    $img->sizelimit_x = THUMB_W_VIDEO;
    $img->sizelimit_y = THUMB_H_VIDEO;
    $img->keep_proportions = true;
    $img->output = 'JPG';
    
    $uniq_id = $_POST['uniq_id'] ?: substr(md5(time()), 1, 8);
    $new_name = $uniq_id . '-1';
    $file_url = _THUMBS_DIR . $new_name . '.jpg';
    
    if (!$img->resize_image($file['tmp_name'])) {
        echo pm_alert_error($img->error, ['id' => '_error_']);
        return;
    }
    
    $img->save_resizedimage(_THUMBS_DIR_PATH, $new_name);
    generate_social_thumb(_THUMBS_DIR_PATH . $new_name .'.jpg');
    
    $html = '<img id="show-thumb" class="show-thumb-temp" src="'. $file_url .'?cachebuster='. time() .'" vspace="" hspace="" border="0" alt="" />';
    $html .= '<input type="hidden" name="yt_thumb_local" value="'. $file_url .'" />';
    
    echo $html;
}

function processCategoryImage($file) {
    require_once('img.resize.php');
    
    $img = new resize_img();
    $img->sizelimit_x = 320;
    $img->sizelimit_y = 180;
    $img->keep_proportions = true;
    $img->output = 'JPG';
    
    $category_id = (int) ($_POST['cat_id'] ?? 0);
    $random_str = substr(md5($category_id . time()), 0, 11);
    $file_url = _THUMBS_DIR . $random_str . '.jpg';
    
    if (!$img->resize_image($file['tmp_name'])) {
        echo pm_alert_error($img->error, ['id' => '_error_']);
        return;
    }
    
    $img->save_resizedimage(_THUMBS_DIR_PATH, $random_str);
    
    $html = '<img id="show-cat-cover" class="show-thumb-temp" src="'. $file_url .'?cachebuster='. time() .'" vspace="" hspace="" border="0" alt="" />';
    $html .= '<input type="hidden" name="image" value="'. $random_str .'.jpg" />';
    
    echo $html;
}