<?php
// +------------------------------------------------------------------------+
// | PHP Melody ( www.phpsugar.com )
// +------------------------------------------------------------------------+
// | PHP Melody IS NOT FREE SOFTWARE
// | If you have downloaded this software from a website other
// | than www.phpsugar.com or if you have received
// | this software from someone who is not a representative of
// | PHPSUGAR, you are involved in an illegal activity.
// | ---
// | In such case, please contact: support@phpsugar.com.
// +------------------------------------------------------------------------+
// | Developed by: PHPSUGAR (www.phpsugar.com) / support@phpsugar.com
// | Copyright: (c) 2004-2013 PHPSUGAR. All rights reserved.
// +------------------------------------------------------------------------+

session_start();
require('config.php');
require_once('include/functions.php');
require_once('include/user_functions.php');
require_once('include/islogged.php');

$cat_name = secure_sql($_GET['cat']);
$page = $_GET['page'];
$sortby = secure_sql($_GET['sortby']);
$order = secure_sql($_GET['order']);

if ( ! in_array($sortby, array('views', 'date', 'rating', 'title')))
{
	$sortby = '';
}

if ( ! in_array($order, array('desc', 'asc', 'DESC', 'ASC')))
{
	$order = '';
}

if($sortby == 'views') {
	$sql_sortby = 'site_views';
	$order = 'DESC';
}
elseif($sortby == 'date') {
	$sql_sortby = 'added';
	$order = 'DESC';
}
elseif($sortby == 'rating') {
	$sql_sortby = 'total_value';
	$order = 'DESC';
}
elseif($sortby == 'title') {
	$sql_sortby = 'video_title';
	$order = 'ASC';
}

if ( ! empty ($cat_name))
{
	$cats = $cat_id = get_catid($cat_name);
	if ( empty ($cat_id))
	{
		header("Location: index."._FEXT);
		exit;
	}

	$limit = _BROWSER_PAGE;
	$category_name = get_catname($cat_name);
	$list_subcats = list_subcategories($cat_id, '');
}
else
{
	$categories_data = load_categories(array('db_table' => 'pm_categories', 'with_image' => true));
	$smarty->assign('list_categories', list_categories());
	$smarty->assign('categories_data', $categories_data);
	$smarty->assign('meta_title', htmlspecialchars(_SITENAME .' - '. $lang['_categories']));
	$smarty->assign('meta_keywords', '');
	$smarty->assign('meta_description', '');
	$smarty->assign('template_dir', $template_f);
	$smarty->display('video-categories-page.tpl');
	exit();
}

if (empty($page) || !is_numeric($page) || $page < 0 ) { $page = 1 ; }
if(is_numeric($cat_id)){
	$resync = 0;
	$category = array();
	$total_items = 0;
	$categories = load_categories(array('db_table' => 'pm_categories'));
	foreach ($categories as $c_id => $c)
	{
		if ($c_id == $cat_id)
		{
			$category = $c;
		}
	}
	$total_items = $category['published_videos'];
	$set_limit = $page * $limit - ($limit);
	if ($total_items == 0) 
	{
			$problem = $lang['browse_msg2'];
	}
	else
	{
		if (isset($sortby) && isset($order)) 
		{
			$sql_sortby	= ($sql_sortby == '') ? "added" : $sql_sortby;
			$order		= ($order == '') ? "DESC" : $order;
		}
		if ($sortby == 'rating')
		{
			$sql = "SELECT pm_videos.uniq_id, COALESCE(pm_bin_rating_meta.score, 0) as score 
				FROM pm_videos 
				LEFT JOIN pm_bin_rating_meta ON (pm_videos.uniq_id = pm_bin_rating_meta.uniq_id) 
				WHERE added <= '". $time_now_minute ."' 
				AND (category LIKE '%,$cat_id,%' 
					 OR category like '%,$cat_id' 
					 OR category like '$cat_id,%' 
					 OR category='$cat_id') 
				AND (video_type = ". IS_VIDEO ." OR video_type = 4)
				ORDER BY score DESC
				LIMIT $set_limit, $limit" ;
			$result = mysql_query($sql);
			$uniq_ids = array();
			while ($row = mysql_fetch_array($result)) 
			{ 
				$uniq_ids[] = $row['uniq_id'];
			} 
			mysql_free_result($result);
			$videos = array();
			$videos = get_video_list('', '', 0, $limit, 0, array(), $uniq_ids);
		}
		else
		{
			$videos = get_video_list($sql_sortby, $order, $set_limit, $limit, $cat_id);
		}
	}
}
else { 
	header("Location: index."._FEXT);
	exit();
}

$pagination = '';
if ($total_items > $limit)
{
	$append_url = '';
	if ( ! _SEOMOD)
	{
		$filename = 'category.php';
		if($cat_name != '') $append_url .= 'cat=' . $cat_name;
		if($page != '') $append_url .= '&page=' . $page;
		if($sortby != '') $append_url .= '&sortby=' . $sortby;
		if($order != '') $append_url .= '&order=' . $order;
	}
	else
	{
		$filename = "browse-" . $cat_name . "-videos-" . $page . "-" . $sortby . ".html";
	}
	$pagination = generate_smart_pagination($page, $total_items, $limit, 1, $filename, $append_url, _SEOMOD);
}

// تحسين سيو - اسم الموقع: عناكب نت anakbnet
$site_name_full = 'عناكب نت anakbnet';
$default_meta_title = $category_name . ' - مشاهدة أحدث الأفلام والمسلسلات والأنميات بجودة HD | ' . $site_name_full;
$default_meta_description = "شاهد أفضل محتوى قسم {$category_name} مجانًا على موقع {$site_name_full}، أحدث الأفلام والمسلسلات والأنمي اون لاين بجودة عالية HD.";
$og_image = ($category['image']) ? _URL . _THUMBS_DIR . '/' . $category['image'] : '';

$meta_title = ($category['meta_title'] != '') 
	? $category['meta_title'] . ' | مشاهدة أحدث الأفلام والمسلسلات عبر موقع ' . $site_name_full
	: $default_meta_title;

$meta_description = ($category['meta_description'] != '') 
	? $category['meta_description'] . ' - عبر موقع ' . $site_name_full . ' لمشاهدة وتحميل أحدث الفيديوهات.'
	: $default_meta_description;

$meta_keywords = $category['meta_keywords'];

// OG & Schema.org Markup
$smarty->assign('og_image', $og_image);
$smarty->assign('schema_category', [
	"@context" => "https://schema.org",
	"@type" => "CollectionPage",
	"name" => $category_name,
	"description" => $meta_description,
	"image" => $og_image,
	"url" => _URL . '/category.php?cat=' . $cat_name
]);

if(!empty($cat_id)) {
	$list_cats = list_categories(0, $cat_id);
	$smarty->assign('list_categories', $list_cats);
} else {
	$list_cats = list_categories(0, '');
	$smarty->assign('list_categories', $list_cats);
}

if($config['show_tags'] == 1)
{
	$tag_cloud = tag_cloud(0, $config['tag_cloud_limit'], $config['shuffle_tags']);
	$smarty->assign('tags', $tag_cloud);
	$smarty->assign('show_tags', 1);
}

$smarty->assign('cat_id', $cat_id);
$smarty->assign('problem', $problem);
$smarty->assign('gv_category_name', $category_name);
$smarty->assign('gv_cat', $cat_name);
$smarty->assign('gv_pagenumber', $page);
$smarty->assign('gv_sortby', $sortby);
$smarty->assign('gv_category_description', $category['description']);
$smarty->assign('list_subcats', str_replace(['ماي سيما','مسلسل'], ['',''], $list_subcats));
$smarty->assign('pagination', $pagination);
$smarty->assign('page_count_info', $page_count_info);
$smarty->assign('pag_left', $pag_left);
$smarty->assign('pag_right', $pag_right);
$smarty->assign('results', $videos);
$smarty->assign('categories_data', load_categories());

// --- DEFAULT SYSTEM FILES - DO NOT REMOVE --- //
$smarty->assign('meta_title', htmlspecialchars($meta_title));
$smarty->assign('meta_keywords', $meta_keywords);
$smarty->assign('meta_description', htmlspecialchars($meta_description));
$smarty->assign('template_dir', $template_f);
$smarty->display('video-category.tpl');
