document.addEventListener('DOMContentLoaded', function() {
  var buttons = document.querySelectorAll('.like-button, .dislike-button');
  if (!buttons.length) return;  // لا يوجد أزرار → لا نفعل شيئًا

  buttons.forEach(function(btn) {
    btn.addEventListener('click', function() {
      var vid    = btn.getAttribute('data-video-id');
      var action = btn.classList.contains('like-button') ? 'like' : 'dislike';

      fetch('/include/rate_like.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'video_id=' + encodeURIComponent(vid) +
              '&action='   + encodeURIComponent(action)
      })
      .then(function(res) {
        if (!res.ok) throw new Error('Status ' + res.status);
        return res.json();
      })
      .then(function(data) {
        if (data.status === 'ok') {
          document.getElementById('like-count-'    + vid).textContent = data.likes;
          document.getElementById('dislike-count-' + vid).textContent = data.dislikes;
          // تغيير حالة الزرّ
          btn.classList.add('active');
          var other = action==='like' ? '.dislike-button' : '.like-button';
          document.querySelector(other+'[data-video-id="'+vid+'"]').classList.remove('active');
        } else {
          alert(data.message);
        }
      })
      .catch(function() {
        alert('❌ خطأ في الاتصال بالسيرفر');
      });
    });
  });
});
