{* ========================================
   ملف: include/video-tool-box.tpl
   ======================================== *}

{* المتغيرات المتاحة: $vid, $likes, $dislikes, $user_liked, $video_data, $base_url *}

<div class="video-tool-box" data-video-id="{$vid}">

  <!-- التقييم (يمين) -->
  <div class="rating-box rating-container" data-video-id="{$vid}">
    <div class="rating-stars">
      {section name=star loop=5}
        <span class="star" data-value="{math equation="x+1" x=$smarty.section.star.index}">&#9733;</span>
      {/section}
    </div>
    <div class="rating-info">
      <span class="average-rating" id="rating-avg-{$vid}">0.0</span>
      <span class="rating-count" id="rating-count-{$vid}">(0 تقييم)</span>
    </div>
  </div>

  <!-- لايك - ديسلايك - مشاركة (شمال) -->
  <div class="like-dislike-share">
    <div class="like-button {if $user_liked === 1}active{/if}" data-video-id="{$vid}">
      <span class="icon">👍</span>
      <span class="count" id="like-count-{$vid}">{$likes|default:0}</span>
    </div>

    <div class="dislike-button {if $user_liked === 0}active{/if}" data-video-id="{$vid}">
      <span class="icon">👎</span>
      <span class="count" id="dislike-count-{$vid}">{$dislikes|default:0}</span>
    </div>

    <div class="share-button">
      <a href="#shareModal" data-toggle="modal" data-target="#shareModal" title="شارك عبر مواقع التواصل">
        <span class="icon">🔗</span><span>شارك</span>
      </a>
    </div>
  </div>

</div>

<!-- ✅ مودال المشاركة -->
<div class="modal fade" id="shareModal" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">مشاركة الفيديو</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="إغلاق">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="share-social-links">
          {assign var="watch_url" value="{$base_url}/watch.php?vid={$video_data.uniq_id|escape:'url'}"}
          {assign var="title" value="{$video_data.video_title|escape:'url'}"}

          <ul class="share-social-list list-inline unstyled">
            <li><a class="facebook" href="https://www.facebook.com/sharer.php?u={$watch_url}&t={$title}" target="_blank"><i class="fab fa-facebook-f"></i><span>Facebook</span></a></li>
            <li><a class="twitter" href="https://twitter.com/intent/tweet?url={$watch_url}&text={$title}" target="_blank"><i class="fab fa-twitter"></i><span>Twitter</span></a></li>
            <li><a class="whatsapp" href="https://wa.me/?text={$watch_url}" target="_blank"><i class="fab fa-whatsapp"></i><span>WhatsApp</span></a></li>
            <li><a class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url={$watch_url}&title={$title}" target="_blank"><i class="fab fa-linkedin-in"></i><span>LinkedIn</span></a></li>
            <li><a class="pinterest" href="https://pinterest.com/pin/create/button/?url={$watch_url}&description={$title}" target="_blank"><i class="fab fa-pinterest"></i><span>Pinterest</span></a></li>
            <li><a class="reddit" href="https://reddit.com/submit?url={$watch_url}&title={$title}" target="_blank"><i class="fab fa-reddit-alien"></i><span>Reddit</span></a></li>
            <li><a class="telegram" href="https://t.me/share/url?url={$watch_url}&text={$title}" target="_blank"><i class="fab fa-telegram-plane"></i><span>Telegram</span></a></li>
            <li><a class="tumblr" href="https://www.tumblr.com/widgets/share/tool?canonicalUrl={$watch_url}&title={$title}" target="_blank"><i class="fab fa-tumblr"></i><span>Tumblr</span></a></li>
            <li><a class="vk" title="شارك على VK" href="https://vk.com/share.php?act=share&url={$watch_url}&title={$title}" target="_blank" onclick="window.open(this.href,'','menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;">
              <i class="fab fa-vk"></i><span>VK</span>
            </a></li>
            <li><a class="email" href="mailto:?subject={$title}&body={$watch_url}"><i class="fas fa-envelope"></i><span>Email</span></a></li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>
