<?php
// +------------------------------------------------------------------------+
// | PHP Melody ( www.phpsugar.com )
// +------------------------------------------------------------------------+
// | PHP Melody IS NOT FREE SOFTWARE
// | If you have downloaded this software from a website other
// | than www.phpsugar.com or if you have received
// | this software from someone who is not a representative of
// | PHPSUGAR, you are involved in an illegal activity.
// | ---
// | In such case, please contact: support@phpsugar.com.
// +------------------------------------------------------------------------+
// | Developed by: PHPSUGAR (www.phpsugar.com) / support@phpsugar.com
// | Copyright: (c) 2004-2016 PHPSUGAR. All rights reserved.
// +------------------------------------------------------------------------+

$showm = '2';

$_page_title = 'Change Links';
include('header.php');


?>
<!-- Main content -->
<div class="content-wrapper">
<div class="page-header-wrapper"> 
	<div class="page-header page-header-light">
		<div class="page-header-content header-elements-md-inline">
		<div class="d-flex justify-content-between w-100">
			<div class="page-title d-flex">
				<h4><span class="font-weight-semibold"><?php echo $_page_title; ?></span></h4>
			</div>
		</div>
		</div>

		<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
			<div class="d-flex">
			<div class="d-horizontal-scroll">
				<div class="breadcrumb">
					<a href="index.php" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Home</a>
					<span class="breadcrumb-item active"><?php echo $_page_title; ?></span>
				</div>
			</div>
			</div>

			<div class="header-elements d-none d-md-block"><!--d-none-->
				<div class="breadcrumb justify-content-center">
				</div>
			</div>
		</div>
	</div>
	<!-- /page header -->
</div><!--.page-header-wrapper-->

	<!-- Content area -->
	<div class="content">	

	<div class="card">
		<div class="card-header">
			<h5>Change Links</h5>
		</div>

		<div class="card-body">
			
			<div class="mb-2">
			<div class="text-uppercase font-size-xs font-weight-semibold">Urls (each in new line):</div>
			</div>
			<textarea id="change_links_urls" name="change_links_urls" rows="10" class="form-control w-100"></textarea>
			<div class="d-flex-inline align-self-center mt-2">
				<div class="">
					<button id="start_change_links" type="button" name="submit" value="Save" class="btn btn-sm btn-outline alpha-success text-success-400 border-success-400 border-2 legitRipple"><i class="mi-flash-on"></i> Start</button>
				</div>
			</div>
			<div id="change_links_res" class="align-self-center mt-2 container font-size-lg"></div>
		</div>
	</div>
</div><!-- .content -->


 
<script>
     
    
    	$('#start_change_links').click(function(event){
		event.preventDefault();
		$('#start_change_links').attr('disabled', true);
		$.ajax({
			url: 'admin-ajax.php',
			data: {
				"p": 'change_links_process',
				"do": 'change_links',
				"urls": $('#change_links_urls').val(),
			},
			type: 'POST',
			dataType: 'json',
			success: function(data){
				$.notify({message: data.msg}, {type: data.alert_type});
				$('#start_change_links').removeAttr('disabled');
				if (data.success === true){
					$('#change_links_res').html(data.html);
				}
			}
		});
		return false;
	});
    
    </script>



<?php
include('footer.php');