<?php
// +------------------------------------------------------------------------+
// | PHP Melody ( www.phpsugar.com )
// +------------------------------------------------------------------------+
// | PHP Melody IS NOT FREE SOFTWARE
// | If you have downloaded this software from a website other
// | than www.phpsugar.com or if you have received
// | this software from someone who is not a representative of
// | PHPSUGAR, you are involved in an illegal activity.
// | ---
// | In such case, please contact: support@phpsugar.com.
// +------------------------------------------------------------------------+
// | Developed by: PHPSUGAR (www.phpsugar.com) / support@phpsugar.com
// | Copyright: (c) 2004-2013 PHPSUGAR. All rights reserved.
// +------------------------------------------------------------------------+

$showm = 'mod_servers';
$load_scrolltofixed = 1;
$_page_title = 'Manage servers';
include('header.php');

$action = $_GET['do'];
if ( ! in_array($action, array('edit', 'new', 'delete')) )
{
	$action = 'new';	//	default action
}


$action	= (int) $_GET['action'];
$current_servers	= (int) $_GET['page'];

if($current_servers == 0)
	$current_servers = 1;

$total_pages = 0;
$limit = get_admin_ui_prefs('servers_pp');

$from = $current_servers * $limit - ($limit);

$filter = '';
$filters = array('mostviewed','embed', 'download');
$filter_value = '';

if(in_array(strtolower($_GET['filter']), $filters) !== false)
{
	$filter = strtolower($_GET['filter']);
	$filter_value = $_GET['fv'];
}

//	Batch delete
if ($_POST['submit'] == "Delete" && ! csrfguard_check_referer('_admin_servers'))
{
	$info_msg = pm_alert_error('Invalid token or session expired. Please revisit this servers and try again.');
}
else if ($_POST['submit'] == "Delete")
{
	if(pm_count($_POST['checkboxes']) > 0)
	{
		$page_ids = array();
		foreach ($_POST['checkboxes'] as $k => $id)
		{
			$page_ids[] = (int) $id;
		}
		
		$result = massDeleteServers($page_ids);
		
		if ($result['type'] == 'error')
		{
			$info_msg = pm_alert_error($result['msg']);
		}
		else
		{
			$info_msg = pm_alert_success($result['msg']);
		}
	}
	else
	{
		$info_msg = pm_alert_warning('Please select something first.');
	}
}

if ('' != $_POST['submit'] && $_POST['submit'] == 'Search')
{
	$pages = listServers($_POST['keywords'], $_POST['search_type'], $from , $limit); 
	$total_pages = pm_count($pages);
}
else
{
	switch ($filter)
	{
            default:
		case 'mostviewed':
			$total_pages = count_entries('servers', '', '');
		
		break;
		case 'embed':
		
			$total_pages = count_entries('servers', 'types', 'embed');
		
		break;

		case 'download':
		
			$total_pages = count_entries('servers', 'types', 'download');
		
		break;
	}
	$pages = listServers('', '', $from , $limit, $filter, $filter_value);
}

// generate smart pagination
$filename = 'servers.php';
$pagination = '';

if( ! isset($_POST['submit']))
{
	$pagination = a_generate_smart_pagination($current_servers, $total_pages, $limit, 5, $filename, '');
}
?>

<!-- Main content -->
<div class="content-wrapper">
<div class="page-header-wrapper"> 
	<div class="page-header page-header-light">
		<div class="page-header-content header-elements-md-inline">
		<div class="d-flex justify-content-between w-100">
			<div class="page-title d-flex">
				<h4><span class="font-weight-semibold"><?php echo $_page_title; ?></span> <a href="edit-servers.php?do=new" class="badge badge-success badge-addnew font-size-sm ml-2">+ add new</a></h4>
			</div>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="mi-search"></i></a>
			<div class="header-elements with-search d-none">
				<div class="d-flex-inline align-self-center ml-auto">
					<form name="search" action="servers.php" method="post" class="form-search-listing form-inline float-right">
						<div class="input-group input-group-sm input-group-search">
							<div class="input-group-append">
								<input name="keywords" type="text" value="<?php echo $_POST['keywords']; ?>" class="search-query search-quez input-medium form-control form-control-sm border-right-0" placeholder="Enter keyword" id="form-search-input" />
							</div>
							<select name="search_type" class="form-control form-control-sm border-left-0 border-right-0">
								<option value="name" <?php echo ($_POST['search_type'] == 'name') ? 'selected="selected"' : '';?>>Name</option>
							</select>
							<div class="input-group-append">
							<button type="submit" name="submit" class="btn btn-light border-left-0" value="Search" id="submitFind"><i class="mi-search"></i><span class="findLoader"><img src="img/ico-loader.gif" width="16" height="16" /></span></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		</div>

		<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
			<div class="d-flex">
				<div class="breadcrumb">
					<a href="index.php" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Home</a>
					<a href="servers.php" class="breadcrumb-item">Servers</a>
					<span class="breadcrumb-item active"><?php echo $_page_title; ?></span>
				</div>
			</div>
		</div>

<?php if ( $total_pages > 0 || !empty($filter)) : ?> <!--Start ifempty-->
		<div class="row p-0 mt-1 ml-0 mr-2">
			<div class="col-md-12">
				<ul class="nav nav-pills nav-pills-bottom m-0">
					<li class="nav-item">
						<a class="nav-link <?php echo (empty($filter) ) ? 'active' : ''; ?>" href="servers.php">All <?php echo (empty($filter)) ? '<span class="text-muted">('. pm_number_format(count_entries('servers', '', '')) .')</span>' : ''; ?></a>
					</li>
					<li class="nav-item">
						<a class="nav-link <?php echo ($filter == 'embed') ? 'active' : '';?>" href="servers.php?filter=embed">Embed <?php echo ($filter == 'embed') ? '<span class="text-muted">('. pm_number_format($total_pages) .')</span>' : ''; ?></a>
					</li>
					<li class="nav-item">
						<a class="nav-link <?php echo ($filter == 'download') ? 'active' : '';?>" href="servers.php?filter=download">Download <?php echo ($filter == 'download') ? '<span class="text-muted">('. pm_number_format($total_pages) .')</span>' : ''; ?></a>
					</li>
				</ul>
			</div>
		</div>
<?php endif; ?> <!--End ifempty-->
	</div><!--.page-header -->
</div>
	<!-- Content area -->
	<div class="content content-full-width">

<?php if ( $total_pages == 0 && empty($filter)) : ?> <!--Start ifempty-->

<div class="align-middle text-center mt-3 pt-3">
	<i class="icon-files-empty icon-3x text-muted mb-3"></i>
	<h6 class="font-weight-semibold text-grey mb-1"><?php echo (!empty($_POST['keywords'])) ? 'No such servers found' : 'No servers yet';?></h6>
	<p class="text-grey mb-3 pb-1">Create a new server now.</p>
	<a href="edit-servers.php?do=new" class="btn btn-sm bg-blue border-blue border-2 rounded font-weight-semibold">Add Servers</a>
</div>

<?php else : ?> <!--Else ifempty-->

<?php echo $info_msg; ?>
  
<div id="display_result" style="display:none;"></div>

	<div class="card card-blanche">
		<div class="card-body">
		<div class="row">
			<div class="col-sm-12 col-md-6">
			<?php if ( ! empty($_POST['keywords'])) : ?>
			<h5 class="font-weight-semibold mt-2">SEARCH RESULTS FOR <mark><?php echo $_POST['keywords']; ?></mark> <a href="#" onClick="parent.location='servers.php'" class="text-muted opacity-50" data-popup="tooltip" data-original-title="Clear search results"><i class="icon-cancel-circle2"></i></a></h5>
			<?php endif; ?>
			</div>
			<div class="col-sm-12 col-md-6 d-none d-md-block">
				<div class="float-right mb-3">
					<form name="servers_per_page" action="servers.php" method="get" class="form-inline float-right">
						<input type="hidden" name="ui_pref" value="servers_pp" />
						<label class="mr-1" for="inlineFormCustomSelectPref">Entries/page</label>
						<select name="results" class="custom-select custom-select-sm w-auto" onChange="this.form.submit()" >
						<option value="25" <?php if($limit == 25) echo 'selected="selected"'; ?>>25</option>
						<option value="50" <?php if($limit == 50) echo 'selected="selected"'; ?>>50</option>
						<option value="75" <?php if($limit == 75) echo 'selected="selected"'; ?>>75</option>
						<option value="100" <?php if($limit == 100) echo 'selected="selected"'; ?>>100</option>
						<option value="125" <?php if($limit == 125) echo 'selected="selected"'; ?>>125</option>
						</select>
						<?php
						// filter persistency
						if (strlen($_SERVER['QUERY_STRING']) > 0)
						{
							$pieces = explode('&', $_SERVER['QUERY_STRING']);
							foreach ($pieces as $k => $val)
							{
								$p = explode('=', $val);
								if ($p[0] != 'page' && $p[0] != 'results') :	
								?>
								<input type="hidden" name="<?php echo $p[0];?>" value="<?php echo $p[1];?>" />
								<?php 
								endif;
							}
						}
						?>
					</form>
				</div>
			</div>
		</div> <!--.row with filters -->
	</div><!--.card-body-->



<form name="pages_checkboxes" id="pages_checkboxes" action="servers.php?page=<?php echo $current_servers;?>" method="post">
<div class="datatable-scroll">
<table cellpadding="0" cellspacing="0" width="100%" class="table table-md table-striped table-columned pm-tables tablesorter">
<thead>
	<tr>
	<th align="center" class="text-center" width="3%"><input type="checkbox" name="checkall" id="selectall" onclick="checkUncheckAll(this);"/></th>
	<th width="">Servers</th>
	<th width="10%" class="text-center">Type</th>	
	<th style="text-align:center; width: 90px;">Action</th>
	</tr>
</thead>
<tbody>
<?php 


if ( ! array_key_exists('type', $pages) && $total_pages > 0)
{
	$alt = 1;
	
	foreach ($pages as $k => $page)
	{
		$col = ($alt % 2) ? 'table_row1' : 'table_row2';
		$alt++;
		
		?>
		 
		<tr class="<?php echo $col;?>" id="page-<?php echo $page['id'];?>">
		 <td align="center" class="text-center" width="3%">
			<input name="checkboxes[]" type="checkbox" value="<?php echo $page['id']; ?>" />
		 </td>
		 <td>
		   <a><?php echo htmlspecialchars($page['name']); ?></a>
		 </td>
		 <td align="center" class="text-center">
			<a href="" title="Edit"><?=$page['types'];?></a>
		 </td>
		 <td align="center" class="text-center table-col-action">
			<div class="list-icons">
				<a href="edit-servers.php?do=edit&id=<?php echo $page['id'];?>" class="list-icons-item mr-2" rel="tooltip" title="Edit"><i class="icon-pencil7"></i></a> 
				<!--<a href="#" onclick="onpage_delete_page('<?php echo $page['id']; ?>', '#display_result', '#page-<?php echo $page['id'];?>')" class="list-icons-item text-warning" rel="tooltip" title="Delete"><i class="icon-bin"></i></a>-->
			</div>
		 </td>
		</tr>
		
		<?php
	}
}
else	//	Error?
{
	if (strlen($pages['msg']) > 0)
	{
		echo pm_alert_error($pages['msg']);
	}
	
	if ($total_pages == 0)
	{
		?>
		<tr>
		 <td colspan="8" align="center" class="text-center">
		 No Servers found.
		 </td>
		</tr>
		<?php
	}
}
?>
	
<?php if ($pagination != '') : ?>
<tr class="tablePagination">
	<td colspan="7" class="tableFooter">
		<div class="table table-md table-striped table-columned pm-tables tablesorter"><?php echo $pagination; ?></div>
	</td>
</tr>
<?php endif; ?>
</tbody>
</table>
</div>

	<div class="datatable-footer">
		<div id="stack-controls" class="row list-controls">
			<div class="col-md-12">
				<div class="float-right form-inline">
					<button type="submit" name="submit" value="Delete" class="btn btn-sm btn-danger" onClick="return confirm_delete_all();">Delete</button>
				</div>
			</div>
		</div><!-- #list-controls -->
		 
	</div>

<?php echo csrfguard_form('_admin_servers');?>
</form>
</div><!--.card-->
<?php endif ?> <!--End ifempty-->
</div><!-- .content -->
<?php
include('footer.php');