{include file='header.tpl' p="general" tpl_name="video-series-page"}
{if pm_count($series_data) > 0}
<div id="content" class="content-series-page">
	<div class="series-header">
		<div class="row">
			<div class="col-md-12">
				<div class="pm-series-brief">
					<div class="pm-poster-img">
						<img src="{$series_data.image_url}" alt="{$series_data.attr_alt}" width="145">
					</div>

					<div class="pm-series-meta">
						<h1>
							{$series_data.title} {if $series_data.release_year}({$series_data.release_year}){/if}
							{if $logged_in && $is_admin == 'yes'}
								<a href="{$smarty.const._URL}/{$smarty.const._ADMIN_FOLDER}/edit-series.php?do=edit&series_id={$series_data.series_id}" target="_blank" class="btn btn-sm btn-primary ml-3 py-1 px-2 hidden-xs hidden-sm" rel="tooltip" title="{$lang.edit} ({$lang._admin_only})">{$lang.edit}</a>
							{/if}
						</h1>

						{if !empty($series_data.description)}
							<div class="pm-series-description">
								<div itemprop="description">
									<p>{$series_data.description}</p>
								</div>
							</div>
						{/if}
                                              <div class="pm-series-details my-3 py-3">
							{if pm_count($series_data.genres) > 0}
							<div class="d-flex justify-content-start p-1">
								<span class="font-weight-bold wmin-100">{$lang._genre|default:"Genre"}</span>
								<ul class="list-unstyled list-inline">
									{foreach $series_data.genres key=k item=genre_data}
										<li><a href="{$genre_data.url}" class="font-weight-semibold">{$genre_data.name}</a></li>
									{/foreach}
								</ul>
							</div>
							{/if}

							<div class="d-flex justify-content-start p-1">
								<span class="font-weight-bold wmin-100">{$lang._seasons|default:"Seasons"}</span> <span>{$series_data.seasons_count} / {$series_data.seasons}</span>
							</div>
							<div class="d-flex justify-content-start p-1">
								<span class="font-weight-bold wmin-100">{$lang._episodes|default:"Episodes"}</span> <span>{$series_data.episodes_count} / {$series_data.episodes}</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="clearfix"></div>

<div class="container-fluid">
            <div class="panel-group mt-10" id="accordion" role="tablist" aria-multiselectable="true">
                <div class="serie_eps">
				<div class="SeasonsBox">
					<div class="SeasonsBoxUL seasons-on-serie">
						<p class="seasonEp">Seasons & episodes</p>
						
                                                <div class="Tab">
                                                    {foreach from=$seasons_data key=season_no item=season name=seasons_loop}
							
                                                        <button  class="tablinks {if $season_no == 1} active {/if}" onclick="openCity(event, '{$lang._season|default:'Season'}{$season_no}')">Season {$season_no}</button>
                                                        {/foreach}
						</div>
                                                
					</div>
					 <div class="SeasonsEpisodesMains">
						
                                                <div class="Tab" style="color: black">
                                                {foreach from=$seasons_data key=season_no item=season name=seasons_loop}
                                                    <div id="Season{$season_no}" class="tabcontent" {if $season_no != 1}style="display: none;"{/if}>  
                                                        <ul class="row pm-ul-browse-videos list-unstyled" id="pm-grid" style="animation-duration: 0ms; opacity: 1;">
                                                    {foreach from=$season item=item_data name=season_episodes_loop}
                                                        <li class="col-lg-5th col-md-5th col-sm-5th col-xs-5th">
                                                            {include file='block-episode.tpl'}
                                                        </li>
                                                           
                                                    {/foreach}
                                                     </ul>
                                                        
                                                    </div>
                                                     {foreachelse}
                                                    <div class="row">
                                                            <div class="col-md-12 text-center">
                                                                    <p></p>
                                                                    <p class="m-3 p-3">{$lang.browse_msg2}</p>			
                                                            </div>
                                                    </div>
                                            {/foreach}
                                                 </div>
						
					</div> 
				</div>
			</div>
		 
		 
	</div><!--.panel-group-->


</div>

{else}

<div id="content" class="content-series-page">
	<div class="row">
		<div class="col-md-12 text-center">
			<p class="m-3 p-3">{$lang.browse_msg2}</p>
		</div>
	</div>
</div>
{/if}

</div>



{include file="footer.tpl" tpl_name="mosalsalat"}

